        public string psgInsert(string remote_table, string fieldKey, string valueKey, bool returnSql)
        {           
            string command_ = string.Empty, tid;
            
            Intf.lc_result = "NOK";            
            this.Intf.newID = string.IsNullOrEmpty(valueKey) ? Sys2015 : valueKey;
            tid = Base.GetParameters(this.Intf.newID.Trim(), "C");
            command_ = "PsgInsert#\"" + remote_table + "|" + fieldKey + " = " + tid + "|\"";

            if (returnSql)
                return command_;
            else
            {
                this.Intf.send_commandSQL(command_);
                ParameterizedThreadStart pts = new ParameterizedThreadStart(CheckInsert);
                Thread t = new Thread(pts);
                t.Start(row);
                return string.Empty;
            }
        }
        
        public string psgDelete(string remote_table, string fieldKey, string valueKey, bool returnSql)
        {
            if (string.IsNullOrEmpty(valueKey))
                return string.Empty;

            string command_, tid = string.Empty;
            
            Intf.lc_result = "NOK";
            this.Intf.deleteIDs.Add(valueKey);
            tid = Utils.StrConv(valueKey.Trim());
            command_ = "PsgDelete#'" + remote_table + "','" + fieldKey + "','" + valueKey + "'";
            

            if (returnSql)
                return command_;
            else
            {
                Intf.send_commandSQL(command_);
                Thread thread = new Thread(new ThreadStart(CheckDelete));
                thread.Start();
                return string.Empty;
            }
        }
        
        
        public string psgUpdate(string remote_table, string valueKey, string fieldKey, string value, string field, string fieldType, bool returnSql)
        {
            Intf.lc_result = "NOK";
            
            string command_, tid, value = string.Empty;
            
            tid = Base.GetParameters(valueKey, "C");
            value = Base.GetParameters(value, fieldType);
            command_ = "UPDATEFIELD#'" + remote_table + "','" + fieldKey + "'," + tid + ",'" + field + "'," + value;

            if (returnSql)
                return command_;
            else
            {
                this.Intf.send_command(command_);
                Thread thread = new Thread(new ThreadStart(CheckUpdate));
                thread.Start();
                return string.Empty;
            }
        }
        
        public void psgMultiCommand(ref List<string> _mc)
        {
        
            Intf.lc_result = "NOK";            
            string command_, tid, value = string.Empty;
            
            command_ = "MULTICOMMAND#" + (char)17 + Utils.Base64(Utils.GetMultiCommand(_mc)) + (char)17;
            
            this.Intf.send_commandSQL(command_);
            ThreadStart pts = new ThreadStart(CheckMultiCommand);
            Thread t = new Thread(pts);
            t.Start();
            
            _mc.Clear();
        }